------------------------------------------------------------------------------
-- List Frame Render Times, Revision: 2.0 
--
-- comp script
--
-- This script outputs the 'per tool' render times for the last frame. The 
-- tools times are displayed in order from longest to shortest. Tools with a
-- render time of 0 are not listed.
--
-- written by : Isaac Guenard (izyk@eyeonline.com)
-- 			June 21st, 2004
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------------------------

function time_sort(t1, t2)
	if t1:GetAttrs().TOOLN_LastFrameTime > t2:GetAttrs().TOOLN_LastFrameTime then
		return true
	end
end

tools = composition:GetToolList()
total = 0

table.sort(tools, time_sort)

print()
print("----------------------------------------------------------------------------------")
print("                          Frame Render Times Per Tool                             ")
print("----------------------------------------------------------------------------------")

for i, tool in pairs(tools) do
	attrs = tool:GetAttrs()
	
	if attrs.TOOLN_LastFrameTime > 0 then
		print(string.format("%30s", attrs.TOOLS_Name), attrs.TOOLN_LastFrameTime)
		total = total + attrs.TOOLN_LastFrameTime
	end
	
end

print("----------------------------------------------------------------------------------")
print("Total = "..total)
print("----------------------------------------------------------------------------------")
print()
